#-----------------------------------------------------------------------
#
#          SANOA DONNEES BRUTES VERS FICHIERS INDIVIDUELS
#
#-----------------------------------------------------------------------
#
# Script construit pour le fichier des donnees ESQUIF de l'ete 1998.
# Pour traiter un autre fichier de meme format, changer le nom dans
# le script de lancement "SanoaRaw2Esq".
#
# Donnees brutes: Manuel PINHARANDA - Service d'Aeronomie
#                 Osvaldo ANTIVILO  - Service d'Aeronomie
#                 Jean-Pierre POMMEREAU  - Service d'Aeronomie
#                 Robert VAUTARD - LMD
#                 Cecile HONORE - LMD
#                 Laurent MENUT - LMD
#
# Programme AWK:  Laurent MENUT - LMD (lmenut@lmd.ens.fr)
# Derniere revision: Fevrier 1998
#-----------------------------------------------------------------------
#
# Cree un fichier avec:
# Colonne 1 = la date en heure decimale
#            (de la date de debut a la date de fin)
#             La date de debut est notee 0
# Colonne 2 = La valeur du polluant choisi
# Colonne 3 = L'ecart-type du polluant choisi, calcule
#             pendant la periode d'integration de l'instrument
#-----------------------------------------------------------------------
FILENAME==ficnom {
  if(FNR == 1){print "---------------------------------------------"}
  if(FNR == 1){print "--- Lecture de " ficnom}
  if(FNR > 1){
      date[FNR-1]=$1
      flux375[FNR-1]=$2
      flux280[FNR-1]=$3
      flux250[FNR-1]=$4
      Chno2[FNR-1]=$5
      Ehno2[FNR-1]=$6
      Ch2o[FNR-1]=$7
      Eh2o[FNR-1]=$8
      Co3[FNR-1]=$9
      Eo3[FNR-1]=$10
      Cnaph[FNR-1]=$11
      Enaph[FNR-1]=$12
      Ctol[FNR-1]=$13
      Etol[FNR-1]=$14
      Cbenz[FNR-1]=$15
      Ebenz[FNR-1]=$16
      Cmxyl[FNR-1]=$17
      Emxyl[FNR-1]=$18
      Cpxyl[FNR-1]=$19
      Epxyl[FNR-1]=$20
      Cno[FNR-1]=$21
      Eno[FNR-1]=$22
      Cno2[FNR-1]=$23
      Eno2[FNR-1]=$24
      Cso2[FNR-1]=$25
      Eso2[FNR-1]=$26
      Co4[FNR-1]=$27
      Eo4[FNR-1]=$28
      nline=FNR
      print FNR "  lignes lues"
  }
}
END{

print "---> Fin de lecture des donnees brutes dans Avril_Aout_98.BLK"

# Decomposition de la date de debut et de fin
  jdeb=substr(datedeb,1,2)
  mdeb=substr(datedeb,3,2)
  andeb=substr(datedeb,5,2)
  hdeb=0
  jfin=substr(datefin,1,2)
  mfin=substr(datefin,3,2)
  anfin=substr(datefin,5,2)
  hfin=24
  if(mdeb < 10)mdeb=substr(mdeb,2,1)-1
  if(mfin < 10)mfin=substr(mfin,2,1)-1
  
# Calendrier
  tab[1]=31
  tab[3]=31
  tab[4]=30
  tab[5]=31
  tab[6]=30
  tab[7]=31
  tab[8]=31
  tab[9]=30
  tab[10]=31
  tab[11]=30
  tab[12]=31
  if (andeb % 4 == 0){tab[2]=29}
  if (andeb % 4 != 0){tab[2]=28}
  
# Calcul du jour Julien correspondant a la date de debut  
    jjdeb=0
    for (i=1;i<=mdeb;i++){
      	jjdeb=jjdeb+tab[i]
    }
    jjdeb=jjdeb+jdeb+hdeb/24.
    
# Calcul du jour Julien correspondant a la date de fin 
    jjfin=0
    for (i=1;i<=mfin;i++){
      	jjfin=jjfin+tab[i]
    }
    jjfin=jjfin+jfin+hfin/24.
    
    print "-- Demande d extraction pour la periode " jjdeb " a " jjfin
    
#  Extraction entre jjdeb et jjfin

  for (k=1;k<=nline;k++){
  
    if(date[k]>= jjdeb && date[k]<= jjfin){
    
    time=(date[k]-jjdeb)*24.
    
    if(Chno2[k] > 0){
    printf("%-f %-f %-f \n",time,Chno2[k],Ehno2[k]) >> "ESQ_Sanoa_" datedeb "_" datefin "_hno2"
    }
    if(Ch2o[k] > 0){
    printf("%-f %-f %-f \n",time,Ch2o[k],Eh2o[k]) >> "ESQ_Sanoa_" datedeb "_" datefin "_h2o" 
    }
    if(Co3[k] > 0){
    printf("%-f %-f %-f \n",time,Co3[k],Eo3[k]) >> "ESQ_Sanoa_" datedeb "_" datefin "_o3" 
    }
    if(Cnaph[k] > 0){
    printf("%-f %-f %-f \n",time,Cnaph[k],Enaph[k]) >> "ESQ_Sanoa_" datedeb "_" datefin "_naph" 
    }
    if(Ctol[k] > 0){
    printf("%-f %-f %-f \n",time,Ctol[k],Etol[k]) >> "ESQ_Sanoa_" datedeb "_" datefin "_tol" 
    }
    if(Cbenz[k] > 0){
    printf("%-f %-f %-f \n",time,Cbenz[k],Ebenz[k]) >> "ESQ_Sanoa_" datedeb "_" datefin "_benz" 
    }
    if(Cmxyl[k] > 0){
    printf("%-f %-f %-f \n",time,Cmxyl[k],Emxyl[k]) >> "ESQ_Sanoa_" datedeb "_" datefin "_mxyl" 
    }
    if(Cpxyl[k] > 0){
    printf("%-f %-f %-f \n",time,Cpxyl[k],Epxyl[k]) >> "ESQ_Sanoa_" datedeb "_" datefin "_pxyl" 
    }
    if(Cno[k] > 0){
    printf("%-f %-f %-f \n",time,Cno[k],Eno[k]) >> "ESQ_Sanoa_" datedeb "_" datefin "_no" 
    }
    if(Cno2[k] > 0){
    printf("%-f %-f %-f \n",time,Cno2[k],Eno2[k]) >> "ESQ_Sanoa_" datedeb "_" datefin "_no2" 
    }
    if(Cso2[k] > 0){
    printf("%-f %-f %-f \n",time,Cso2[k],Eso2[k]) >> "ESQ_Sanoa_" datedeb "_" datefin "_so2" 
    }
    if(Co4[k] > 0){
    printf("%-f %-f %-f \n",time,Co4[k],Eo4[k]) >> "ESQ_Sanoa_" datedeb "_" datefin "_o4" 
    }

#  En plus, Ox et NOx
    if(Cno2[k] > 0 && Co3[k] > 0 ){
    printf("%-f %-f %-f \n",time,Co3[k]+Cno2[k],Eo3[k]+Eno2[k]) >> "ESQ_Sanoa_" datedeb "_" datefin "_Ox"
    }
    if(Cno2[k] > 0 && Cno[k] > 0 ){
    printf("%-f %-f %-f \n",time,Cno[k]+Cno2[k],Eno[k]+Eno2[k]) >> "ESQ_Sanoa_" datedeb "_" datefin "_NOx" 
    }
    
    }
  }
  
}
